USE [msdb]
GO
/****** Object: Job [Sauvegarde base DB_SQLPRO] Script Date: 10/29/2012 14:02:47 ******/
BEGIN TRANSACTION
DECLARE @ReturnCode INT
SELECT @ReturnCode = 0
/****** Object: JobCategory [Sauvegarde] Script Date: 10/29/2012 14:02:47 ******/
IF NOT EXISTS (SELECT name FROM msdb.dbo.syscategories WHERE name=N'Sauvegarde' AND
category_class=1)
BEGIN
   EXEC @ReturnCode = msdb.dbo.sp_add_category @class=N'JOB', @type=N'LOCAL', @name=N'Sauvegarde'
   IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
END
DECLARE @jobId BINARY(16)
EXEC @ReturnCode = msdb.dbo.sp_add_job @job_name=N'Sauvegarde base DB_SQLPRO',
     @enabled=1,
     @notify_level_eventlog=0,
     @notify_level_email=2,
     @notify_level_netsend=0,
     @notify_level_page=0,
     @delete_level=0,
     @description=N'Ralise la sauvegarde complte de la base DB_SQLPRO et la place dans le rpertoire par dfaut des sauvegardes',
     @category_name=N'Sauvegarde',
     @owner_login_name=N'sa',
     @notify_email_operator_name=N'OPA_notification_travaux', @job_id = @jobId OUTPUT
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
/****** Object: Step [Sauvegarde complte de la base SQLpro dans le rpertoire temp] Script Date:
10/29/2012 14:02:47 ******/
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'Sauvegarde complte de la base SQLpro dans le rpertoire temp',
     @step_id=1,
     @cmdexec_success_code=0,
     @on_success_action=3,
     @on_success_step_id=0,
     @on_fail_action=2,
     @on_fail_step_id=0,
     @retry_attempts=0,
     @retry_interval=0,
     @os_run_priority=0, @subsystem=N'TSQL',
     @command=N'BACKUP DATABASE DB_SQLPRO TO DISK = ''C:\temp\DB_SQLPRO.bak'';',
     @database_name=N'master',
     @flags=4
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
/****** Object: Step [Copie le fichier vers le serveur distant] Script Date: 10/29/2012 14:02:47
******/
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'Copie le fichier vers le serveur distant',
     @step_id=2,
     @cmdexec_success_code=0,
     @on_success_action=1,
     @on_success_step_id=0,
     @on_fail_action=2,
     @on_fail_step_id=0,
     @retry_attempts=0,
     @retry_interval=0,
     @os_run_priority=0, @subsystem=N'CmdExec',
     @command=N'COPY /V /Y /B "C:\temp\DB_SQLPRO.bak" /B "\\SRV_DATA\_db_\SQL\"',
     @flags=32
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_update_job @job_id = @jobId, @start_step_id = 1
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_add_jobschedule @job_id=@jobId, @name=N'Planfi Sauvegarde SQLpro',
     @enabled=1,
     @freq_type=4,
     @freq_interval=1,
     @freq_subday_type=1,
     @freq_subday_interval=0,
     @freq_relative_interval=0,
     @freq_recurrence_factor=0,
     @active_start_date=20121029,
     @active_end_date=99991231,
     @active_start_time=40000,
     @active_end_time=235959,
     @schedule_uid=N'4ea746c5-bfb3-4cb0-adb7-e341d50cbf7a'
     IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_add_jobserver @job_id = @jobId, @server_name = N'(local)'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
COMMIT TRANSACTION
GOTO EndSave
QuitWithRollback:
IF (@@TRANCOUNT > 0) ROLLBACK TRANSACTION
EndSave:
GO